<?php

namespace frontend\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\Bots;
use yii\db\Expression;

/**
 * BotsSearch represents the model behind the search form of `common\models\Bots`.
 */
class BotsSearch extends Bots
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'comps', 'status', 'user', 'busy', 'type'], 'integer'],
            [['id','comps','user'],'integer','max'=>2147483647],
            [['status'],'integer','max'=>2],
            [['priority', 'type'],'integer','max'=>4],
            [['busy'],'integer','max'=>1],
            [['bot', 'tz', 'country', 'arch', 'cname', 'path', 'uname', 'av', 'group', 'soft', 'created_at', 'updated_at', 'ip', 'locale', 'ps', 'source', 'os', 'comment', 'trust', 'net', 'domain', 'osbuild'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $accessFilter = json_decode(Yii::$app->user->identity->groups);
        $query = Bots::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $query->andFilterWhere(['group' => $accessFilter]);

        $dataProvider->sort->attributes['updated_at'] = [
            'asc' => [new Expression('bots.updated_at ASC NULLS FIRST')],
            'desc' => [new Expression('bots.updated_at DESC NULLS LAST')]
        ];
        $dataProvider->sort->defaultOrder = ['updated_at' => SORT_DESC];

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'comps' => $this->comps,
            'status' => $this->status,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'user' => $this->user,
            'busy' => $this->busy,
            'type' => $this->type,
            'priority' => $this->priority,
        ]);

        $query->andFilterWhere(['ilike', 'bot', $this->bot])
            ->andFilterWhere(['ilike', 'country', $this->country])
            ->andFilterWhere(['ilike', 'arch', $this->arch])
            ->andFilterWhere(['ilike', 'cname', $this->cname])
            ->andFilterWhere(['ilike', 'path', $this->path])
            ->andFilterWhere(['ilike', 'uname', $this->uname])
            ->andFilterWhere(['ilike', 'av', $this->av])
            ->andFilterWhere(['ilike', 'group', $this->group])
            ->andFilterWhere(['ilike', 'soft', $this->soft])
            ->andFilterWhere(['ilike', 'ip', $this->ip])
            ->andFilterWhere(['ilike', 'locale', $this->locale])
            ->andFilterWhere(['ilike', 'ps', $this->ps])
            ->andFilterWhere(['ilike', 'source', $this->source])
            ->andFilterWhere(['ilike', 'os', $this->os])
            ->andFilterWhere(['ilike', 'comment', $this->comment])
            ->andFilterWhere(['ilike', 'trust', $this->trust])
            ->andFilterWhere(['ilike', 'net', $this->net])
            ->andFilterWhere(['ilike', 'domain', $this->domain])
            ->andFilterWhere(['ilike', 'tz', $this->tz])
            ->andFilterWhere(['ilike', 'osbuild', $this->osbuild]);

        return $dataProvider;
    }
}
